/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************

   In this tutorial is presented how to save and load World states

/******************************************************************************/
Game::ObjMemx<Game::Item> Items;
/******************************************************************************/
void InitPre()
{
   App.name="Lights";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024);

   Cam.dist =10;
   Cam.yaw  =-PI_4;
   Cam.pitch=-0.5;
   Cam.at.set(16,0,16);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sun    .set(*Gfxs("gfx/sky/sun.gfx")).pos.set(0,1,0);
   Sky    .set();

   Game::World.init   (               )
              .setType(Items,OBJ_ITEM )
              .New    ("world/barrels")
              .update (Cam.at         );

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));

   if(Kb.bp(KB_F2))Game::World.save("data/save.sav"); // save game
   if(Kb.bp(KB_F3))Game::World.load("data/save.sav"); // load game

   Game::World.update(Cam.at);

   // add some velocity to objects
   if(Kb.bp(KB_SPACE))REPA(Items)Items[i].actor.addVel(5*Rnd.dir(Vec(0,1,0),0.7));

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press F2 to save and F3 to load");
   D.text(0,0.8,"Press Space to add velocity");
}
/******************************************************************************/
